#ifndef _CLOCK_H
#define _CLOCK_H

#include "GenericTypeDefs.h"

#define EPOCH_YEAR 				2000		/* For the Hardware RTCC */

#define DEFAULT_DURATION_SECS	1293840000L	/* number of seconds since 1970 epoch time to default time, Jan 1, 2011, midnight */

#define CLEAR_ALARM_EVENT		0
#define ALARM_SET_EVENT			1
#define ALARM_TRIGGER_EVENT		2
#define ALARM_FUTURE_EVENT		4

#define SHOW_WDAY				1
#define SHOW_DAY				2
#define SHOW_MINUTES			4
#define SHOW_SECONDS			8
#define SHOW_HOURS				16
#define SHOW_MONTH				32
#define SHOW_YEAR				64

#define SHOW_TIME_DEFAULT		(SHOW_WDAY | SHOW_DAY | SHOW_MONTH | SHOW_HOURS | SHOW_MINUTES | SHOW_SECONDS | SHOW_YEAR)

#define TIME_UPDATED			1
#define DATE_UPDATED			2

typedef struct
{
  unsigned char  secs;			// Seconds.	[0-59] 
  unsigned char  mins;			// Minutes.	[0-59] 
  unsigned char  hours;		    // Hours.	[0-23] 
  unsigned char  day;		    // Day.		[1-31] 
  unsigned char  month;		    // Month.	[1-12] 
  unsigned short year;			// Year.
  unsigned char  wday;          // Weekday (0=Monday, 6=Sunday) (also used as pointer)
  unsigned char	 show;
  unsigned char  updated;
} TIME_T;

extern volatile TIME_T 			systemTime;
extern volatile unsigned int 	timer1OverFlow;
extern volatile unsigned long  	alarmAbsolute;
extern volatile unsigned long   timeAbsolute;
extern volatile unsigned char   alarmEvent;
extern volatile unsigned char	timeUp;

void 			copyTime(TIME_T* timeDest, TIME_T* timeSource);
void 			addMonth(TIME_T* argTimeOutput);
void 			addDay(TIME_T* argTimeOutput);
void 			addHour(TIME_T* argTimeOutput);
void 			addMinute(TIME_T* argTimeOutput);
void 			addSecond(TIME_T* argTimeOutput);
void 			getFutureArgumentTime(TIME_T* argTimeOutput, TIME_T* currentTimeInput);
void 			addMonths(TIME_T* argTimeOutput, long n);
void 			addDays(TIME_T* argTimeOutput, long n);
void 			addHours(TIME_T* argTimeOutput, long n);
void 			addMinutes(TIME_T* argTimeOutput, long n);
void 			addSeconds(TIME_T* argTimeOutput, long n);
void 			checkTime(TIME_T* argTimeOutput);
void 			convertEpoch2TimeInternal(unsigned long epochTime, TIME_T* dest);
unsigned int 	convertBCDToDecimal(unsigned int bcdValue);
unsigned int 	convertDecimalToBCD(unsigned int decValue);
unsigned int 	isLeapYear(unsigned int iyear);
unsigned int 	daysInMonth(unsigned int month, unsigned int year);
void 		 	convertToHoursMins(TIME_T* inTime, float f, int base);
float 			convertFromHoursMins(TIME_T* inTime, int base);
unsigned int 	getWeekDay(unsigned int day, unsigned int month, unsigned int year);
unsigned char* 	ascTime(unsigned char* instr, TIME_T* timet);
unsigned char* 	ascTimeFileName(unsigned char* instr, TIME_T* timet);
unsigned char*  getFileNameTimeString(unsigned char* outstring, rom const unsigned char* baseString, TIME_T* timet);
BYTE* 			getTimeStringSystemTime(BYTE* outstr);
unsigned long 	getDuration(TIME_T* timeOne, TIME_T* timeTwo);
int 			compareTimes(TIME_T* timeOne, TIME_T* timeTwo);
unsigned char* 	getDurationString(unsigned char* outstr, float floatSeconds, int printed);
int 			setTime(TIME_T* sysTime);
int 			getTime(TIME_T* sysTime);
int 			initRTCC(TIME_T* sysTime);
int 			igetTime(TIME_T* sysTime);
void 			doTimer1Interrupt(void);
unsigned char*  ascTimeLog(unsigned char* instr, TIME_T* timet);
BYTE* 			getTimeStringLog(BYTE* outstr);
unsigned long   getTotalSeconds(TIME_T* timet);
long 		  	getDurationTotalSeconds(TIME_T* timeOne, TIME_T* timeTwo);
int 			setAlarmTime(TIME_T* sysTime);
unsigned char*  internalAscTime(unsigned char* instr, TIME_T* timet, unsigned char normal);
unsigned char*  ascTimeNormal(unsigned char* instr, TIME_T* timet);
unsigned long 	scaleTimeSeconds(double timeSpeed, unsigned long offset, unsigned long timeToScale);
void 			scaleTime(double timeSpeed, unsigned long offset, TIME_T* timeToScale);

#endif
